﻿using Microsoft.Xna.Framework;

namespace SampleGame
{
    public class Game1 : Game
    {
        private GraphicsDeviceManager _graphics;
        private Engine _engine;

        public Game1 ()
        {
            _graphics = new GraphicsDeviceManager(this);
        }

        protected override void Initialize ()
        {
            base.Initialize();

            _engine = new Engine(_graphics);
            _engine.Initialize();
        }

        protected override void Update (GameTime gameTime)
        {
            _engine.Update(gameTime);
            base.Update(gameTime);
        }

        protected override void Draw (GameTime gameTime)
        {
            _engine.Draw(gameTime);
            base.Draw(gameTime);
        }
    }
}
