﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Xna.Framework;

namespace WinFormsGraphicsDevice
{
    public class Game1 : GameControl
    {
        private Engine _engine;

        protected override void Initialize ()
        {
            base.Initialize();

            _engine = new Engine(GraphicsDeviceService);
            _engine.Initialize();
        }

        protected override void Update (GameTime gameTime)
        {
            _engine.Update(gameTime);
        }

        protected override void Draw (GameTime gameTime)
        {
            _engine.Draw(gameTime);
        }

        public Color ClearColor
        {
            get { return _engine != null ? _engine.ClearColor : Color.Black; }
            set { if (_engine != null) _engine.ClearColor = value; }
        }
    }
}
